/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidAbsorberTileEntity
extends TickingTileEntity {
    private static final int ABSORB_SPEED = 2;
    private int absorbing = 0;
    private Block absorbingBlock = null;
    private int timer = 2;
    private final Set<BlockPos> toscan = new HashSet<BlockPos>();
    private final FakePlayerGetter harvester = new FakePlayerGetter((GenericTileEntity)this, "rftools_fluid_absorber");

    public FluidAbsorberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EssencesModule.TYPE_FLUID_ABSORBER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60955_()).tileEntitySupplier(FluidAbsorberTileEntity::new).manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"fluid", FluidAbsorberTileEntity::getFluidName), TooltipBuilder.parameter((String)"progress", FluidAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getFluidName(ItemStack stack) {
        String block = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"fluid", null);
        if (block == null) {
            return "<Not Set>";
        }
        Fluid b = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(block));
        if (b != null) {
            return I18n.m_118938_((String)b.m_76145_().m_76188_().m_60734_().m_7705_(), (Object[])new Object[0]);
        }
        return "<Invalid>";
    }

    public static String getFluid(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"fluid", null);
    }

    private static String getProgressName(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxFluidAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxFluidAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxFluidAbsorption.get();
    }

    protected void tickServer() {
        if (this.absorbing > 0 || this.absorbingBlock == null) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 2;
                BlockState b = this.isValidSourceBlock(this.m_58899_().m_7495_());
                if (b != null) {
                    if (this.absorbingBlock == null) {
                        this.absorbing = (Integer)EssencesConfig.maxFluidAbsorption.get();
                        this.absorbingBlock = b.m_60734_();
                        this.toscan.clear();
                    }
                    this.toscan.add(this.m_58899_().m_7495_());
                }
                if (!this.toscan.isEmpty()) {
                    int r = this.f_58857_.f_46441_.nextInt(this.toscan.size());
                    Iterator<BlockPos> iterator = this.toscan.iterator();
                    BlockPos c = null;
                    for (int i = 0; i <= r; ++i) {
                        c = iterator.next();
                    }
                    this.toscan.remove(c);
                    this.checkBlock(c, Direction.DOWN);
                    this.checkBlock(c, Direction.UP);
                    this.checkBlock(c, Direction.EAST);
                    this.checkBlock(c, Direction.WEST);
                    this.checkBlock(c, Direction.SOUTH);
                    this.checkBlock(c, Direction.NORTH);
                    if (this.blockMatches(c)) {
                        BlockState oldState = this.f_58857_.m_8055_(c);
                        FluidState oldFluidState = this.f_58857_.m_6425_(c);
                        SoundTools.playSound((Level)this.f_58857_, (SoundEvent)this.absorbingBlock.getSoundType(oldFluidState.m_76188_(), (LevelReader)this.f_58857_, c, null).m_56775_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)1.0, (double)1.0);
                        BlockPos finalC = c;
                        FluidTools.pickupFluidBlock((Level)this.f_58857_, (BlockPos)c, s -> true, () -> this.f_58857_.m_7731_(finalC, Blocks.f_50016_.m_49966_(), 2));
                        --this.absorbing;
                        BlockState newState = this.f_58857_.m_8055_(c);
                        this.f_58857_.m_7260_(c, oldState, newState, 3);
                    }
                }
            }
            this.m_6596_();
        }
    }

    protected void tickClient() {
        if (this.absorbing > 0) {
            Random rand = this.f_58857_.f_46441_;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((float)this.m_58899_().m_123341_() + 0.5f) + x * r, (double)((float)this.m_58899_().m_123342_() + 0.5f) + y * r, (double)((float)this.m_58899_().m_123343_() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    private void checkBlock(BlockPos c, Direction direction) {
        BlockPos c2 = c.m_142300_(direction);
        if (this.blockMatches(c2)) {
            this.toscan.add(c2);
        }
    }

    private boolean blockMatches(BlockPos c) {
        FluidState state = this.f_58857_.m_6425_(c);
        if (!state.m_76170_()) {
            return false;
        }
        return state.m_76188_().m_60734_().equals(this.absorbingBlock);
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public Block getAbsorbingBlock() {
        return this.absorbingBlock;
    }

    public Fluid getAbsorbingFluid() {
        if (this.absorbingBlock != null) {
            return this.absorbingBlock.m_49966_().m_60819_().m_76152_();
        }
        return null;
    }

    private BlockState isValidSourceBlock(BlockPos coordinate) {
        if (!BlockAbsorberTileEntity.allowedToBreak(this.f_58857_.m_8055_(coordinate), this.f_58857_, coordinate, (Player)this.harvester.get())) {
            return null;
        }
        FluidState state = this.f_58857_.m_6425_(coordinate);
        if (this.isValidDimletFluid(state)) {
            return state.m_76188_();
        }
        return null;
    }

    private boolean isValidDimletFluid(FluidState fluidState) {
        if (fluidState != null && !fluidState.m_76178_()) {
            if (!fluidState.m_76170_()) {
                return false;
            }
            Fluid fluid = fluidState.m_76152_();
            DimletKey key = new DimletKey(DimletType.FLUID, Tools.getId((Fluid)fluid).toString());
            DimletSettings settings = DimletDictionary.get().getSettings(key);
            return settings != null && settings.isDimlet();
        }
        return false;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        int[] x = tagCompound.m_128465_("toscanx");
        int[] y = tagCompound.m_128465_("toscany");
        int[] z = tagCompound.m_128465_("toscanz");
        this.toscan.clear();
        for (int i = 0; i < x.length; ++i) {
            this.toscan.add(new BlockPos(x[i], y[i], z[i]));
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            Fluid fluid;
            CompoundTag info = tagCompound.m_128469_("Info");
            this.absorbing = info.m_128451_("absorbing");
            if (info.m_128441_("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(info.m_128461_("fluid")))) != null) {
                this.absorbingBlock = fluid.m_76145_().m_76188_().m_60734_();
            }
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        int[] x = new int[this.toscan.size()];
        int[] y = new int[this.toscan.size()];
        int[] z = new int[this.toscan.size()];
        int i = 0;
        for (BlockPos c : this.toscan) {
            x[i] = c.m_123341_();
            y[i] = c.m_123342_();
            z[i] = c.m_123343_();
            ++i;
        }
        tagCompound.m_128385_("toscanx", x);
        tagCompound.m_128385_("toscany", y);
        tagCompound.m_128385_("toscanz", z);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("absorbing", this.absorbing);
        if (this.absorbingBlock != null) {
            info.m_128359_("fluid", Tools.getId((FluidState)this.absorbingBlock.m_49966_().m_60819_()).toString());
        }
    }
}

